; Name:		GroupWise Messenger.jss
; Topic:	JAWS Script File for Novell Messenger

; Copyright (C) 2004 Novell Inc., All Rights Reserved
; COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION

include "hjconst.jsh"

const
	BANNER_TEXT		= 436,
	CHANGE_BUTTON	= 242,
	COMPOSE_FONT	= 243,
	CONTACT_LIST	= 100,
	FIRST_NAME_EDIT	= 381,
	FIRST_NAME_COMBO	= 386,
	FIRST_NAME_LABEL	= 476,
	FONT_NAME_COMBO	= 356,
	FONT_SIZE_COMBO	= 357,
	SEARCH_HELP		= 539,
	SEARCH_RADIO	= 250,
	SEARCH_USERID	= 538,
	STATUS		= 397,
	USER_ID		= 317,
	USER_NAME		= 225,
	VIEWER		= 337

globals
	handle	g_hFindDlg,
	handle	g_hSendDlg


void Function AutoStartEvent ()
;	Say ("auto start event", ot_screen_message);
EndFunction


; function to find a window based on a control id
handle Function FindWindowFromId (handle hWnd, int nId)

	return FindDescendantWindow (GetRealWindow (hWnd), nId)
EndFunction


; called when focus changes
void Function FocusChangedEvent (handle hFocusWnd, handle hPrevWnd)

var	handle hChgBtn,
	handle hContacts,
	handle hFName,
	handle hName,
	handle hUserId,
	int	nRet

	; get certain window handles
	let hChgBtn	= FindWindowFromId (GetFocus (), CHANGE_BUTTON)
	let hContacts	= FindWindowFromId (GetFocus (), CONTACT_LIST)
	let hFName	= FindWindowFromId (GetFocus (), FIRST_NAME_EDIT)
	let hName	= FindWindowFromId (GetFocus (), USER_NAME)
	let hUserId	= FindWindowFromId (GetFocus (), USER_ID)

	; look to see if any of the windows have focus
	if (hName == hFocusWnd) then			; name in basic window
		HandleFocusBasicName (hFocusWnd)
	elif (hUserId == hFocusWnd) then			; userid in basic window
		HandleFocusBasicUserId (hFocusWnd)
	elif (hFName == hFocusWnd) then			; first name in advanced window
		let nRet = HandleFocusAdvancedFName (hFocusWnd)

		; if nRet == 0 we need to pass it on like normal
		if (nRet == 0) then
			FocusChangedEvent (hFocusWnd, hPrevWnd)
		endif
	elif (hContacts == hFocusWnd) then			; contact window
		HandleFocusContactList (hFocusWnd)
	elif (hChgBtn == hFocusWnd) then			; change button in message tab in options dialog
		HandleFocusChangeButton (hFocusWnd)
	else
		FocusChangedEvent (hFocusWnd, hPrevWnd)
	endif
EndFunction


; function to handle focus in find dialog, advanced first name
int Function HandleFocusAdvancedFName (handle hFNameWnd)

var	handle hCombo,
	handle hDlg,
	handle	hLabel

	let hDlg = GetRealWindow (hFNameWnd)

	; if this is the first time in the dialog, say the banner and the label and the combo box value
	if (hDlg != g_hFindDlg) then
		SayBannerText (hDlg)
		let g_hFindDlg = hDlg
	
		let hCombo	= FindWindowFromId (hFNameWnd, FIRST_NAME_COMBO)
		let hLabel	= FindWindowFromId (hFNameWnd, FIRST_NAME_LABEL)

		SayWindow (hLabel, READ_EVERYTHING)
		SayWindow (hCombo, READ_EVERYTHING)

		; return 1 so we know that we said something
		return 1
	endif

	; we didn't say anything
	return 0
EndFunction


; function to read the name in search dialog
Function HandleFocusBasicName (handle hNameWnd)

var	handle hWnd,
	handle	hDlg

	let hDlg = GetRealWindow (hNameWnd)

	if (hDlg != g_hFindDlg) then
		SayBannerText (hDlg)
		let g_hFindDlg = hDlg
	endif

	; say the radio button text
	let hWnd = FindWindowFromId (hNameWnd, SEARCH_RADIO)
	SayWindow (hWnd, READ_EVERYTHING)

	; say the search help text
	let hWnd = FindWindowFromId (hNameWnd, SEARCH_HELP)
	SayWindow (hWnd, READ_EVERYTHING)
EndFunction


; function to read the userid control in search dialog
Function HandleFocusBasicUserId (handle hNameWnd)

var	handle hWnd

	let hWnd = FindWindowFromId (hNameWnd,	SEARCH_USERID)

	SayWindow (hWnd, READ_EVERYTHING)
EndFunction


; function to handle focus in options dialog, message tab, change button
Function HandleFocusChangeButton (handle hChgBtn)

var	handle hWnd,
	handle	hParent

	let hParent = GetParent (hChgBtn)

	; say group box text
	let hWnd = GetFirstChild (hParent)
	SayString (GetWindowName (hWnd))

	; say help text
	let hWnd = GetNextWindow (hWnd)
	SayWindow (hWnd, READ_EVERYTHING)

	; say font name
	let hWnd = FindWindowFromId (hChgBtn, COMPOSE_FONT)
	SayWindow (hWnd, READ_EVERYTHING)

	; say button text
	SayControl (hChgBtn)
EndFunction


; function to handle focus in find dialog, contact list
Function HandleFocusContactList (handle hContacts)

var	handle hDlg,
	handle hParent

	; this should give us the NMContacts window
	let hParent = GetRealWindow (hContacts)

	; this should give us the dialog
	let hDlg = GetParent (hParent)

	; if this is the first time in the dialog, say the banner and the label and the combo box value
	if (hDlg != g_hSendDlg) then
		SayBannerText (hDlg)
		let g_hSendDlg = hDlg
	endif
EndFunction


; function to handle new text in various controls
void Function NewTextEvent (handle hwnd, string sBuffer, int nAttributes, int nTextColor,
	int nBackgroundColor, int nEcho, string sFrameName)

var	handle hViewer,
	handle hFontName,
	handle hFontSize,
	handle hStatus,
	int	nFound

	; get window handles
	let hviewer	= FindWindowFromId (GetFocus (), VIEWER)
	let hFontName	= FindWindowFromId (GetFocus (), FONT_NAME_COMBO)
	let hFontSize	= FindWindowFromId (GetFocus (), FONT_SIZE_COMBO)
	let hStatus	= FindWindowFromId (GetFocus (), STATUS)
	let nFound	= 0

	if (hViewer == hwnd) then		; viewer window
		let nFound = 1
	elif (hFontName == hwnd) then	; font name combobox
		let nFound = 1
	elif (hFontSize == hwnd) then		; font size combobox
		let nFound = 1
	elif (hStatus == hwnd) then		; status window
		let nFound = 1
	else					; do normal event
		NewTextEvent (hwnd, sBuffer, nAttributes, nTextColor, nBackgroundColor,
			nEcho, sFrameName)
	endif

	if (nFound) then
		Say (sBuffer, ot_screen_message);
	endif

EndFunction


; function to say text in banner window
Function SayBannerText (handle hDlg)

var	handle hWnd

	; say the banner text
	let hWnd = FindDescendantWindow (hdlg, BANNER_TEXT)

	if (hWnd) then
		SayWindow (hWnd, READ_EVERYTHING)
	endif
EndFunction


;void Function ValueChangeEvent (handle hwnd, int nObjId, int nChildId, int nObjType,
;	String strName, String strValue)

;	SayString ("In ValueChangeEvent")
;	SayString (strName)
;	SayString (strValue)
;EndFunction
